
varying vec2 v_TexCoord;

uniform sampler2D g_Texture0;
uniform sampler2D g_Texture1;

uniform vec2 g_TexelSize;

#if DISPLAYHDR == 1
uniform vec4 g_RenderVar0;
#endif

// Proper gamma conversion http://chilliant.blogspot.com/2012/08/srgb-approximations-for-hlsl.html
vec3 lin(vec3 v)
{
	vec3 c = step(0.04045, v);
	return c * (pow((v + 0.055) / 1.055, CAST3(2.4))) + (1.0 - c) * (v / 12.92);
}

void main()
{
	vec3 albedo = texSample2D(g_Texture0, v_TexCoord).rgb;
	vec3 bloom1 = texSample2D(g_Texture1, v_TexCoord + g_TexelSize).rgb +
				texSample2D(g_Texture1, v_TexCoord - g_TexelSize).rgb +
				texSample2D(g_Texture1, v_TexCoord + vec2(g_TexelSize.x, -g_TexelSize.y)).rgb +
				texSample2D(g_Texture1, v_TexCoord + vec2(-g_TexelSize.x, g_TexelSize.y)).rgb;
	bloom1 *= 0.25;

#if DISPLAYHDR == 1
	//float referenceBrightness = 80.0;
	//float albedoBrightness = 120.0; // boost to 150%
	//float maxDisplayLuminance = 2.9 * referenceBrightness; // boost to 125%
	//gl_FragColor = vec4(lin(saturate(albedo) * albedoBrightness/referenceBrightness + saturate(bloom1) * (maxDisplayLuminance-albedoBrightness)/referenceBrightness), 1.0);
	// max lum for 1550 nits: 3.58
	gl_FragColor = vec4(lin((max(CAST3(0.0), albedo + bloom1)) * g_RenderVar0.x), 1.0);
#else
#if COMBINEDBG == 1
	albedo = mix(albedo + bloom1, bloom1, step(0.5, v_TexCoord.x) * step(v_TexCoord.y, 0.5));
#else
	albedo += bloom1;
#endif

#if LINEAR == 1
	gl_FragColor = vec4(saturate(albedo), 1.0);
#else
	gl_FragColor = vec4(lin(saturate(albedo)), 1.0);
#endif
#endif

#if 0
	float maxLum = g_RenderVar0.y / 80.0;
	float lum = (gl_FragColor.r + gl_FragColor.g + gl_FragColor.b) / 3.0;
	
	float blendGreen = smoothstep(1.0, maxLum - 0.5, lum);
	float blendRed = smoothstep(maxLum - 0.5, maxLum, lum);
	gl_FragColor.rgb = CAST3(lum);
	gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(0, maxLum - 0.5, 0), saturate(blendGreen));
	gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(maxLum, 0, 0), saturate(blendRed));
	
	// remap to SDR
	//gl_FragColor.rgb /= g_RenderVar0.y / 80.0;
	//gl_FragColor.rgb = saturate(gl_FragColor.rgb);
#endif
}
